function light = convertmask2light(filename,background,r,theta,num_r,num_theta,index)

Data = imread(filename); %Read in Mask
N = size(Data,1); 
M = size(Data,2);
C = size(Data,3);

if (N > M)    
    offset = (N - M)/2;
    x_beginpos = 1 + offset;
    x_endpos = N - offset;
    y_beginpos = 1;
    y_endpos = M;
    N = M;
else
    offset = (M - N)/2;
    y_beginpos = 1 + offset;
    y_endpos = M - offset;
    x_beginpos = 1;
    x_endpos = N;
    M = N;
    
end

%Convert to grayscale, The image must be square. If not, make it square.
if (C > 1)
    image = rgb2gray(Data(x_beginpos:x_endpos, y_beginpos:y_endpos, :));
else
    image = Data(x_beginpos:x_endpos, y_beginpos:y_endpos);
end

%Transform square image onto a circle

Radius = N / 2;
Radius_Offset = 0.10*Radius;
delta_r = 1 / num_r;
delta_th = 2 * pi / num_theta;

%First look at where the discretized volumes lay on top of the image
%(useful for non-uniform light masks)

% color = {'r','m'};
% 
% imshow(image);hold on
% for i=1:length(r)
%     for j=1:length(theta)
%         x = r(i)*cos(theta(j))*Radius + Radius;
%         x_nw = (r(i) + delta_r/2) * cos(theta(j) + delta_th/2)*Radius + Radius;
%         x_ne = (r(i) + delta_r/2) * cos(theta(j) - delta_th/2)*Radius + Radius;
%         x_se = (r(i) - delta_r/2) * cos(theta(j) - delta_th/2)*Radius + Radius;
%         x_sw = (r(i) - delta_r/2) * cos(theta(j) + delta_th/2)*Radius + Radius;
%         
%         y = r(i)*sin(theta(j))*Radius + Radius;
%         y_nw = (r(i) + delta_r/2) * sin(theta(j) + delta_th/2)*Radius + Radius;
%         y_ne = (r(i) + delta_r/2) * sin(theta(j) - delta_th/2)*Radius + Radius;
%         y_se = (r(i) - delta_r/2) * sin(theta(j) - delta_th/2)*Radius + Radius;
%         y_sw = (r(i) - delta_r/2) * sin(theta(j) + delta_th/2)*Radius + Radius;
% 
%         plot([x_nw x_ne x_se x_sw x_nw],[y_nw y_ne y_se y_sw y_nw],color{mod(i,2)+1},x,y,'bo');        
%     end
% end

light = zeros(num_r*num_theta,1);
counts = zeros(num_r*num_theta,1);

for i=1:N %x-direction
    for j=1:N %y-direction
        
        %For each pixel in the image, determine its corresponding radius
        r_coord = sqrt((i - Radius)^2 + (-j + Radius)^2);
        
       
        if (r_coord < Radius - Radius_Offset) %First determine if the pixel is within the circle
                    
            %Calculate the theta coordinate from the pixel location.
            %There are four possible quadrants based on the signs of x,y
            %with corresponding locations
            if ((i - Radius) >= 0 && (j - Radius) >= 0)
                th_coord = abs(atan( (j - Radius) / (i - Radius))) + pi/2 + pi/2;
            elseif ((i - Radius) >= 0 && (j - Radius) < 0)
                th_coord = abs(atan( (i - Radius) / (j - Radius))) + pi/2;
            elseif ((i - Radius) < 0 && (j - Radius) < 0)
                th_coord = abs(atan( (j - Radius) / (i - Radius))) + 3*pi/2 + pi/2;
            elseif ((i - Radius) < 0 && (j - Radius) >= 0)
                th_coord = abs(atan( (i - Radius) / (j - Radius))) + pi + pi/2;
            end                                                               
             
            if (th_coord > 2*pi)
                th_coord = th_coord - 2*pi;
            end
            
            %Then determine which discretized volume it belongs in
            %1) Scale r_coord
            r_coord = r_coord * r(num_r) / Radius;

            %2) Identify which discretized radial component it's in


            r_coord = max(1,round( (r_coord - r(1)) / delta_r) + 1);

            %3) Identify which discretized degree component it's in
            if (th_coord > theta(num_theta))
                th_coord = num_theta;
            else
                th_coord = max(1,round( (th_coord - theta(1)) / delta_th) + 1);
            end
            
              %Let's average the pixel intensities.
%            light(index(r_coord,th_coord)) = light(index(r_coord,th_coord)) + double(image(i,j));
            counts(index(r_coord,th_coord)) = counts(index(r_coord,th_coord)) + 1;

            %Max/Min of pixel intensities.
             
            if (counts(index(r_coord,th_coord)) == 1)
                 light(index(r_coord,th_coord)) = double(image(i,j));
            else
             
                if (background > 255/2) %background is more white
                    light(index(r_coord,th_coord)) = min(light(index(r_coord,th_coord)),double(image(i,j)));
                else %background is more dark
                    light(index(r_coord,th_coord)) = max(light(index(r_coord,th_coord)),double(image(i,j)));
                end
            end
            
        end
        
    end
end

% light = light ./ max(1,counts);
light(find(counts == 0)) = background;

